/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelEffectPacket;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelScreen;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSetItemMenu;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSlotPositioning;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedClientHandler;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.mixin.accessor.ItemStackLinkedSetAccessor;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.NetworkHooks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.joml.Math;

public class FactoryPanelBehaviour
extends FilteringBehaviour
implements class_3908 {
    public static final BehaviourType<FactoryPanelBehaviour> TOP_LEFT = new BehaviourType();
    public static final BehaviourType<FactoryPanelBehaviour> TOP_RIGHT = new BehaviourType();
    public static final BehaviourType<FactoryPanelBehaviour> BOTTOM_LEFT = new BehaviourType();
    public static final BehaviourType<FactoryPanelBehaviour> BOTTOM_RIGHT = new BehaviourType();
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    public Map<class_2338, FactoryPanelConnection> targetedByLinks;
    public Set<FactoryPanelPosition> targeting;
    public List<class_1799> activeCraftingArrangement;
    public boolean satisfied;
    public boolean promisedSatisfied;
    public boolean waitingForNetwork;
    public String recipeAddress;
    public int recipeOutput;
    public LerpedFloat bulb;
    public FactoryPanelBlock.PanelSlot slot;
    public int promiseClearingInterval;
    public boolean forceClearPromises;
    public UUID network;
    public boolean active;
    public boolean redstonePowered;
    public RequestPromiseQueue restockerPromises;
    private boolean promisePrimedForMarkDirty;
    private int lastReportedUnloadedLinks;
    private int lastReportedLevelInStorage;
    private int lastReportedPromises;
    private int timer;

    public FactoryPanelBehaviour(FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(be, new FactoryPanelSlotPositioning(slot));
        this.slot = slot;
        this.targetedBy = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        this.targetedByLinks = new HashMap<class_2338, FactoryPanelConnection>();
        this.targeting = new HashSet<FactoryPanelPosition>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.waitingForNetwork = false;
        this.activeCraftingArrangement = List.of();
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.active = false;
        this.forceClearPromises = false;
        this.redstonePowered = false;
        this.promiseClearingInterval = -1;
        this.bulb = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.175, LerpedFloat.Chaser.EXP);
        this.restockerPromises = new RequestPromiseQueue(() -> ((FactoryPanelBlockEntity)be).method_5431());
        this.promisePrimedForMarkDirty = true;
        this.network = UUID.randomUUID();
        this.setLazyTickRate(40);
    }

    public void setNetwork(UUID network) {
        this.network = network;
    }

    @Nullable
    public static FactoryPanelBehaviour at(class_1920 world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof FactoryPanelBehaviour) {
            FactoryPanelBehaviour fbe = (FactoryPanelBehaviour)cached;
            if (!fbe.blockEntity.method_11015()) {
                return fbe;
            }
        }
        FactoryPanelBehaviour result = FactoryPanelBehaviour.at(world, connection.from);
        connection.cachedSource = new WeakReference<FactoryPanelBehaviour>(result);
        return result;
    }

    @Nullable
    public static FactoryPanelBehaviour at(class_1920 world, FactoryPanelPosition pos) {
        class_1937 l;
        if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(pos.pos())) {
            return null;
        }
        class_2586 class_25862 = world.method_8321(pos.pos());
        if (!(class_25862 instanceof FactoryPanelBlockEntity)) {
            return null;
        }
        FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)class_25862;
        FactoryPanelBehaviour behaviour = fpbe.panels.get((Object)pos.slot());
        if (!behaviour.active) {
            return null;
        }
        return behaviour;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(class_1920 world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof FactoryPanelSupportBehaviour) {
            FactoryPanelSupportBehaviour fpsb = (FactoryPanelSupportBehaviour)cached;
            if (!fpsb.blockEntity.method_11015()) {
                return fpsb;
            }
        }
        FactoryPanelSupportBehaviour result = FactoryPanelBehaviour.linkAt(world, connection.from);
        connection.cachedSource = new WeakReference<FactoryPanelSupportBehaviour>(result);
        return result;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(class_1920 world, FactoryPanelPosition pos) {
        class_1937 l;
        if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(pos.pos())) {
            return null;
        }
        return BlockEntityBehaviour.get((class_1922)world, pos.pos(), FactoryPanelSupportBehaviour.TYPE);
    }

    public void moveTo(FactoryPanelPosition newPos, class_3222 player) {
        BlockEntityBehaviour at;
        FactoryPanelBlockEntity fpbe;
        class_1937 level = this.getWorld();
        class_2680 existingState = level.method_8320(newPos.pos());
        if (FactoryPanelBehaviour.at((class_1920)level, newPos) != null) {
            return;
        }
        boolean isAddedToOtherGauge = AllBlocks.FACTORY_GAUGE.has(existingState);
        if (!existingState.method_26215() && !isAddedToOtherGauge) {
            return;
        }
        if (isAddedToOtherGauge && existingState != this.blockEntity.method_11010()) {
            return;
        }
        if (!isAddedToOtherGauge) {
            level.method_8652(newPos.pos(), this.blockEntity.method_11010(), 3);
        }
        for (class_2338 class_23382 : this.targetedByLinks.keySet()) {
            if (class_23382.method_19771((class_2382)newPos.pos(), 24.0)) continue;
            return;
        }
        for (FactoryPanelPosition factoryPanelPosition : this.targetedBy.keySet()) {
            if (factoryPanelPosition.pos().method_19771((class_2382)newPos.pos(), 24.0)) continue;
            return;
        }
        for (FactoryPanelPosition factoryPanelPosition : this.targeting) {
            if (factoryPanelPosition.pos().method_19771((class_2382)newPos.pos(), 24.0)) continue;
            return;
        }
        for (class_2338 class_23383 : this.targetedByLinks.keySet()) {
            FactoryPanelSupportBehaviour at2 = FactoryPanelBehaviour.linkAt((class_1920)level, new FactoryPanelPosition(class_23383, this.slot));
            if (at2 == null) continue;
            at2.disconnect(this);
        }
        SmartBlockEntity oldBE = this.blockEntity;
        FactoryPanelPosition factoryPanelPosition = this.getPanelPosition();
        this.moveToSlot(newPos.slot());
        class_2586 class_25862 = level.method_8321(newPos.pos());
        if (class_25862 instanceof FactoryPanelBlockEntity) {
            fpbe = (FactoryPanelBlockEntity)class_25862;
            fpbe.attachBehaviourLate(this);
            fpbe.panels.put(this.slot, this);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }
        if (oldBE instanceof FactoryPanelBlockEntity) {
            fpbe = (FactoryPanelBlockEntity)oldBE;
            FactoryPanelBehaviour newBehaviour = new FactoryPanelBehaviour(fpbe, factoryPanelPosition.slot());
            fpbe.attachBehaviourLate(newBehaviour);
            fpbe.panels.put(factoryPanelPosition.slot(), newBehaviour);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }
        for (FactoryPanelPosition position : this.targeting) {
            at = FactoryPanelBehaviour.at((class_1920)level, position);
            if (at == null) continue;
            FactoryPanelConnection connection = ((FactoryPanelBehaviour)at).targetedBy.remove(factoryPanelPosition);
            connection.from = newPos;
            ((FactoryPanelBehaviour)at).targetedBy.put(newPos, connection);
            ((FactoryPanelBehaviour)at).blockEntity.sendData();
        }
        for (FactoryPanelPosition position : this.targetedBy.keySet()) {
            at = FactoryPanelBehaviour.at((class_1920)level, position);
            if (at == null) continue;
            ((FactoryPanelBehaviour)at).targeting.remove(factoryPanelPosition);
            ((FactoryPanelBehaviour)at).targeting.add(newPos);
        }
        for (class_2338 pos : this.targetedByLinks.keySet()) {
            at = FactoryPanelBehaviour.linkAt((class_1920)level, new FactoryPanelPosition(pos, this.slot));
            if (at == null) continue;
            ((FactoryPanelSupportBehaviour)at).connect(this);
        }
        player.method_7353((class_2561)CreateLang.translate("factory_panel.relocated", new Object[0]).style(class_124.field_1060).component(), true);
        player.method_37908().method_8396(null, newPos.pos(), class_3417.field_26960, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void moveToSlot(FactoryPanelBlock.PanelSlot slot) {
        this.slot = slot;
        ValueBoxTransform valueBoxTransform = this.getSlotPositioning();
        if (valueBoxTransform instanceof FactoryPanelSlotPositioning) {
            FactoryPanelSlotPositioning fpsp = (FactoryPanelSlotPositioning)valueBoxTransform;
            fpsp.slot = slot;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.notifyRedstoneOutputs();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getWorld().method_8608()) {
            if (this.blockEntity.isVirtual()) {
                this.tickStorageMonitor();
            }
            this.bulb.updateChaseTarget(this.redstonePowered || this.satisfied ? 1.0f : 0.0f);
            this.bulb.tickChaser();
            if (this.active) {
                this.tickOutline();
            }
            return;
        }
        if (!this.promisePrimedForMarkDirty) {
            this.restockerPromises.setOnChanged(() -> ((SmartBlockEntity)this.blockEntity).method_5431());
            this.promisePrimedForMarkDirty = true;
        }
        this.tickStorageMonitor();
        this.tickRequests();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.getWorld().method_8608()) {
            return;
        }
        this.checkForRedstoneInput();
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        boolean shouldPower = false;
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().method_8477(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = FactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), connection);
            if (linkAt == null) {
                return;
            }
            shouldPower |= linkAt.shouldPanelBePowered();
        }
        if (shouldPower == this.redstonePowered) {
            return;
        }
        this.redstonePowered = shouldPower;
        this.blockEntity.notifyUpdate();
        this.timer = 1;
    }

    private void notifyRedstoneOutputs() {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getWorld().method_8477(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = FactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), connection);
            if (linkAt == null || linkAt.isOutput()) {
                return;
            }
            linkAt.notifyLink();
        }
    }

    private void tickStorageMonitor() {
        boolean shouldWait;
        class_1799 filter = this.getFilter();
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int demand = this.getAmount() * (this.upTo ? 1 : filter.method_7914());
        int unloadedLinkCount = this.getUnloadedLinks();
        boolean shouldSatisfy = filter.method_7960() || inStorage >= demand;
        boolean shouldPromiseSatisfy = filter.method_7960() || inStorage + promised >= demand;
        boolean bl = shouldWait = unloadedLinkCount > 0;
        if (this.lastReportedLevelInStorage == inStorage && this.lastReportedPromises == promised && this.lastReportedUnloadedLinks == unloadedLinkCount && this.satisfied == shouldSatisfy && this.promisedSatisfied == shouldPromiseSatisfy && this.waitingForNetwork == shouldWait) {
            return;
        }
        if (!this.satisfied && shouldSatisfy && demand > 0) {
            AllSoundEvents.CONFIRM.playOnServer(this.getWorld(), (class_2382)this.getPos(), 0.075f, 1.0f);
            AllSoundEvents.CONFIRM_2.playOnServer(this.getWorld(), (class_2382)this.getPos(), 0.125f, 0.575f);
        }
        boolean notifyOutputs = this.satisfied != shouldSatisfy;
        this.lastReportedLevelInStorage = inStorage;
        this.satisfied = shouldSatisfy;
        this.lastReportedPromises = promised;
        this.promisedSatisfied = shouldPromiseSatisfy;
        this.lastReportedUnloadedLinks = unloadedLinkCount;
        this.waitingForNetwork = shouldWait;
        if (!this.getWorld().field_9236) {
            this.blockEntity.sendData();
        }
        if (notifyOutputs) {
            this.notifyRedstoneOutputs();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tickRequests() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (this.targetedBy.isEmpty() && !panelBE.restocker) {
            return;
        }
        if (panelBE.restocker) {
            this.restockerPromises.tick();
        }
        if (this.satisfied || this.promisedSatisfied || this.waitingForNetwork || this.redstonePowered) {
            return;
        }
        if (this.timer > 0) {
            this.timer = Math.min((int)this.timer, (int)this.getConfigRequestIntervalInTicks());
            --this.timer;
            return;
        }
        this.resetTimer();
        if (this.recipeAddress.isBlank()) {
            return;
        }
        if (panelBE.restocker) {
            this.tryRestock();
            return;
        }
        boolean failed = false;
        HashMap<UUID, Map> consolidated = new HashMap<UUID, Map>();
        for (FactoryPanelConnection factoryPanelConnection : this.targetedBy.values()) {
            FactoryPanelBehaviour factoryPanelBehaviour = FactoryPanelBehaviour.at((class_1920)this.getWorld(), factoryPanelConnection);
            if (factoryPanelBehaviour == null) {
                return;
            }
            class_1799 item = factoryPanelBehaviour.getFilter();
            Map networkItemCounts = consolidated.computeIfAbsent(factoryPanelBehaviour.network, $ -> new Object2ObjectOpenCustomHashMap(ItemStackLinkedSetAccessor.getTYPE_AND_TAG()));
            networkItemCounts.computeIfAbsent(item, $ -> new ItemStackConnections(item));
            ItemStackConnections itemStackConnections = (ItemStackConnections)networkItemCounts.get(item);
            itemStackConnections.add(factoryPanelConnection);
            itemStackConnections.totalAmount += factoryPanelConnection.amount;
        }
        HashMultimap toRequest = HashMultimap.create();
        for (Map.Entry entry : consolidated.entrySet()) {
            UUID network = (UUID)entry.getKey();
            Iterator summary = LogisticsManager.getSummaryOfNetwork(network, true);
            for (ItemStackConnections connections : ((Map)entry.getValue()).values()) {
                if (connections.totalAmount == 0 || connections.item.method_7960() || ((InventorySummary)((Object)summary)).getCountOf(connections.item) < connections.totalAmount) {
                    for (FactoryPanelConnection connection : connections) {
                        this.sendEffect(connection.from, false);
                    }
                    failed = true;
                    continue;
                }
                BigItemStack stack2 = new BigItemStack(connections.item, connections.totalAmount);
                toRequest.put((Object)network, (Object)stack2);
                for (FactoryPanelConnection connection : connections) {
                    this.sendEffect(connection.from, true);
                }
            }
        }
        if (failed) {
            return;
        }
        Map map = toRequest.asMap();
        PackageOrderWithCrafts packageOrderWithCrafts = PackageOrderWithCrafts.empty();
        ArrayList<Multimap<PackagerBlockEntity, PackagingRequest>> requests = new ArrayList<Multimap<PackagerBlockEntity, PackagingRequest>>();
        if (!this.activeCraftingArrangement.isEmpty()) {
            PackageOrderWithCrafts packageOrderWithCrafts2 = PackageOrderWithCrafts.singleRecipe(this.activeCraftingArrangement.stream().map(stack -> new BigItemStack(stack.method_46651(1))).toList());
        }
        for (Map.Entry entry : map.entrySet()) {
            void var6_13;
            PackageOrderWithCrafts order = new PackageOrderWithCrafts(new PackageOrder(new ArrayList<BigItemStack>((Collection)entry.getValue())), var6_13.orderedCrafts());
            Multimap<PackagerBlockEntity, PackagingRequest> request = LogisticsManager.findPackagersForRequest((UUID)entry.getKey(), order, null, this.recipeAddress);
            requests.add(request);
        }
        for (Multimap multimap : requests) {
            for (PackagerBlockEntity packager : multimap.keySet()) {
                if (!packager.isTooBusyFor(LogisticallyLinkedBehaviour.RequestType.RESTOCK)) continue;
                return;
            }
        }
        for (Multimap multimap : requests) {
            LogisticsManager.performPackageRequests((Multimap<PackagerBlockEntity, PackagingRequest>)multimap);
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises != null) {
            promises.add(new RequestPromise(new BigItemStack(this.getFilter(), this.recipeOutput)));
        }
        panelBE.advancements.awardPlayer(AllAdvancements.FACTORY_GAUGE);
    }

    private void tryRestock() {
        class_1799 item = this.getFilter();
        if (item.method_7960()) {
            return;
        }
        FactoryPanelBlockEntity panelBE = this.panelBE();
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null || !packager.targetInventory.hasInventory()) {
            return;
        }
        int availableOnNetwork = LogisticsManager.getStockOf(this.network, item, packager.targetInventory.getIdentifiedInventory());
        if (availableOnNetwork == 0) {
            this.sendEffect(this.getPanelPosition(), false);
            return;
        }
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int maxStackSize = item.method_7914();
        int demand = this.getAmount() * (this.upTo ? 1 : maxStackSize);
        int amountToOrder = Math.clamp((int)(demand - promised - inStorage), (int)0, (int)(maxStackSize * 9));
        BigItemStack orderedItem = new BigItemStack(item, Math.min((int)amountToOrder, (int)availableOnNetwork));
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(List.of(orderedItem));
        this.sendEffect(this.getPanelPosition(), true);
        if (!LogisticsManager.broadcastPackageRequest(this.network, LogisticallyLinkedBehaviour.RequestType.RESTOCK, order, packager.targetInventory.getIdentifiedInventory(), this.recipeAddress)) {
            return;
        }
        this.restockerPromises.add(new RequestPromise(orderedItem));
    }

    private void sendEffect(FactoryPanelPosition fromPos, boolean success) {
        AllPackets.sendToNear(this.getWorld(), this.getPos(), 64, new FactoryPanelEffectPacket(fromPos, this.getPanelPosition(), success));
    }

    public void addConnection(FactoryPanelPosition fromPos) {
        FactoryPanelSupportBehaviour link = FactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), fromPos);
        if (link != null) {
            this.targetedByLinks.put(fromPos.pos(), new FactoryPanelConnection(fromPos, 1));
            link.connect(this);
            this.blockEntity.notifyUpdate();
            return;
        }
        if (this.panelBE().restocker) {
            return;
        }
        if (this.targetedBy.size() >= 9) {
            return;
        }
        FactoryPanelBehaviour source = FactoryPanelBehaviour.at((class_1920)this.getWorld(), fromPos);
        if (source == null) {
            return;
        }
        source.targeting.add(this.getPanelPosition());
        this.targetedBy.put(fromPos, new FactoryPanelConnection(fromPos, 1));
        this.blockEntity.notifyUpdate();
    }

    public FactoryPanelPosition getPanelPosition() {
        return new FactoryPanelPosition(this.getPos(), this.slot);
    }

    public FactoryPanelBlockEntity panelBE() {
        return (FactoryPanelBlockEntity)this.blockEntity;
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        if (!Create.LOGISTICS.mayInteract(this.network, player)) {
            player.method_7353((class_2561)CreateLang.translate("logistically_linked.protected", new Object[0]).style(class_124.field_1061).component(), true);
            return;
        }
        boolean isClientSide = player.method_37908().field_9236;
        if (this.targeting.size() + this.targetedByLinks.size() > 0 && AllTags.AllItemTags.WRENCH.matches(player.method_5998(hand))) {
            int sharedMode = -1;
            boolean notifySelf = false;
            for (FactoryPanelPosition target : this.targeting) {
                FactoryPanelConnection connection;
                FactoryPanelBehaviour at = FactoryPanelBehaviour.at((class_1920)this.getWorld(), target);
                if (at == null || (connection = at.targetedBy.get(this.getPanelPosition())) == null) continue;
                if (sharedMode == -1) {
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                }
                connection.arrowBendMode = sharedMode;
                if (isClientSide) continue;
                at.blockEntity.notifyUpdate();
            }
            for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
                if (sharedMode == -1) {
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                }
                connection.arrowBendMode = sharedMode;
                if (isClientSide) continue;
                notifySelf = true;
            }
            if (sharedMode == -1) {
                return;
            }
            char[] boxes = "\u25a1\u25a1\u25a1\u25a1".toCharArray();
            boxes[sharedMode] = 9632;
            player.method_7353((class_2561)CreateLang.translate("factory_panel.cycled_arrow_path", new String(boxes)).component(), true);
            if (notifySelf) {
                this.blockEntity.notifyUpdate();
            }
            return;
        }
        if (isClientSide && FactoryPanelConnectionHandler.panelClicked((class_1936)this.getWorld(), player, this)) {
            return;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (this.getFilter().method_7960()) {
            if (heldItem.method_7960()) {
                if (!isClientSide && player instanceof class_3222) {
                    class_3222 sp = (class_3222)player;
                    NetworkHooks.openScreen((class_3222)sp, (class_3908)this, buf -> this.getPanelPosition().send((class_2540)buf));
                }
                return;
            }
            super.onShortInteract(player, hand, side, hitResult);
            return;
        }
        if (heldItem.method_7909() instanceof LogisticallyLinkedBlockItem) {
            if (!isClientSide) {
                LogisticallyLinkedBlockItem.assignFrequency(heldItem, player, this.network);
            }
            return;
        }
        if (isClientSide) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.displayScreen(player));
        }
    }

    public void enable() {
        this.active = true;
        this.blockEntity.notifyUpdate();
    }

    public void disable() {
        this.destroy();
        this.active = false;
        this.targetedBy = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        this.targeting = new HashSet<FactoryPanelPosition>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.setFilter(class_1799.field_8037);
        this.blockEntity.notifyUpdate();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public boolean isMissingAddress() {
        return (!this.targetedBy.isEmpty() || this.panelBE().restocker) && this.count != 0 && this.recipeAddress.isBlank();
    }

    @Override
    public void destroy() {
        this.disconnectAll();
        super.destroy();
    }

    public void disconnectAll() {
        FactoryPanelPosition panelPosition = this.getPanelPosition();
        this.disconnectAllLinks();
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            FactoryPanelBehaviour source = FactoryPanelBehaviour.at((class_1920)this.getWorld(), connection);
            if (source == null) continue;
            source.targeting.remove(panelPosition);
            source.blockEntity.sendData();
        }
        for (FactoryPanelPosition position : this.targeting) {
            FactoryPanelBehaviour target = FactoryPanelBehaviour.at((class_1920)this.getWorld(), position);
            if (target == null) continue;
            target.targetedBy.remove(panelPosition);
            target.blockEntity.sendData();
        }
        this.targetedBy.clear();
        this.targeting.clear();
    }

    public void disconnectAllLinks() {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            FactoryPanelSupportBehaviour source = FactoryPanelBehaviour.linkAt((class_1920)this.getWorld(), connection);
            if (source == null) continue;
            source.disconnect(this);
        }
        this.targetedByLinks.clear();
    }

    public int getUnloadedLinks() {
        if (this.getWorld().method_8608()) {
            return this.lastReportedUnloadedLinks;
        }
        if (this.panelBE().restocker) {
            return this.panelBE().getRestockedPackager() == null ? 1 : 0;
        }
        return Create.LOGISTICS.getUnloadedLinkCount(this.network);
    }

    public int getLevelInStorage() {
        if (this.blockEntity.isVirtual()) {
            return 1;
        }
        if (this.getWorld().method_8608()) {
            return this.lastReportedLevelInStorage;
        }
        if (this.getFilter().method_7960()) {
            return 0;
        }
        InventorySummary summary = this.getRelevantSummary();
        return summary.getCountOf(this.getFilter());
    }

    private InventorySummary getRelevantSummary() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (!panelBE.restocker) {
            return LogisticsManager.getSummaryOfNetwork(this.network, false);
        }
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null) {
            return InventorySummary.EMPTY;
        }
        return packager.getAvailableItems(true);
    }

    public int getPromised() {
        if (this.getWorld().method_8608()) {
            return this.lastReportedPromises;
        }
        class_1799 item = this.getFilter();
        if (item.method_7960()) {
            return 0;
        }
        if (this.panelBE().restocker) {
            if (this.forceClearPromises) {
                this.restockerPromises.forceClear(item);
                this.resetTimerSlightly();
            }
            this.forceClearPromises = false;
            return this.restockerPromises.getTotalPromisedAndRemoveExpired(item, this.getPromiseExpiryTimeInTicks());
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises == null) {
            return 0;
        }
        if (this.forceClearPromises) {
            promises.forceClear(item);
            this.resetTimerSlightly();
        }
        this.forceClearPromises = false;
        return promises.getTotalPromisedAndRemoveExpired(item, this.getPromiseExpiryTimeInTicks());
    }

    public void resetTimer() {
        this.timer = this.getConfigRequestIntervalInTicks();
    }

    public void resetTimerSlightly() {
        this.timer = this.getConfigRequestIntervalInTicks() / 2;
    }

    private int getConfigRequestIntervalInTicks() {
        return (Integer)AllConfigs.server().logistics.factoryGaugeTimer.get();
    }

    private int getPromiseExpiryTimeInTicks() {
        if (this.promiseClearingInterval == -1) {
            return -1;
        }
        if (this.promiseClearingInterval == 0) {
            return 600;
        }
        return this.promiseClearingInterval * 20 * 60;
    }

    @Override
    public void writeSafe(class_2487 nbt) {
        if (!this.active) {
            return;
        }
        class_2487 panelTag = new class_2487();
        panelTag.method_10566("Filter", this.getFilter().serializeNBT());
        panelTag.method_10569("FilterAmount", this.count);
        panelTag.method_25927("Freq", this.network);
        panelTag.method_10582("RecipeAddress", this.recipeAddress);
        panelTag.method_10569("PromiseClearingInterval", -1);
        panelTag.method_10569("RecipeOutput", 1);
        nbt.method_10566(CreateLang.asId((String)this.slot.name()), (class_2520)panelTag);
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        if (!this.active) {
            return;
        }
        class_2487 panelTag = new class_2487();
        super.write(panelTag, clientPacket);
        panelTag.method_10569("Timer", this.timer);
        panelTag.method_10569("LastLevel", this.lastReportedLevelInStorage);
        panelTag.method_10569("LastPromised", this.lastReportedPromises);
        panelTag.method_10569("LastUnloadedLinks", this.lastReportedUnloadedLinks);
        panelTag.method_10556("Satisfied", this.satisfied);
        panelTag.method_10556("PromisedSatisfied", this.promisedSatisfied);
        panelTag.method_10556("Waiting", this.waitingForNetwork);
        panelTag.method_10556("RedstonePowered", this.redstonePowered);
        panelTag.method_10566("Targeting", (class_2520)NBTHelper.writeCompoundList(this.targeting, FactoryPanelPosition::write));
        panelTag.method_10566("TargetedBy", (class_2520)NBTHelper.writeCompoundList(this.targetedBy.values(), FactoryPanelConnection::write));
        panelTag.method_10566("TargetedByLinks", (class_2520)NBTHelper.writeCompoundList(this.targetedByLinks.values(), FactoryPanelConnection::write));
        panelTag.method_10582("RecipeAddress", this.recipeAddress);
        panelTag.method_10569("RecipeOutput", this.recipeOutput);
        panelTag.method_10569("PromiseClearingInterval", this.promiseClearingInterval);
        panelTag.method_25927("Freq", this.network);
        panelTag.method_10566("Craft", (class_2520)NBTHelper.writeItemList(this.activeCraftingArrangement));
        if (this.panelBE().restocker && !clientPacket) {
            panelTag.method_10566("Promises", (class_2520)this.restockerPromises.write());
        }
        nbt.method_10566(CreateLang.asId((String)this.slot.name()), (class_2520)panelTag);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        class_2487 panelTag = nbt.method_10562(CreateLang.asId((String)this.slot.name()));
        if (panelTag.method_33133()) {
            this.active = false;
            return;
        }
        this.active = true;
        this.filter = FilterItemStack.of(panelTag.method_10562("Filter"));
        this.count = panelTag.method_10550("FilterAmount");
        this.upTo = panelTag.method_10577("UpTo");
        this.timer = panelTag.method_10550("Timer");
        this.lastReportedLevelInStorage = panelTag.method_10550("LastLevel");
        this.lastReportedPromises = panelTag.method_10550("LastPromised");
        this.lastReportedUnloadedLinks = panelTag.method_10550("LastUnloadedLinks");
        this.satisfied = panelTag.method_10577("Satisfied");
        this.promisedSatisfied = panelTag.method_10577("PromisedSatisfied");
        this.waitingForNetwork = panelTag.method_10577("Waiting");
        this.redstonePowered = panelTag.method_10577("RedstonePowered");
        this.promiseClearingInterval = panelTag.method_10550("PromiseClearingInterval");
        if (panelTag.method_25928("Freq")) {
            this.network = panelTag.method_25926("Freq");
        }
        this.targeting.clear();
        NBTHelper.iterateCompoundList((class_2499)panelTag.method_10554("Targeting", 10), c -> this.targeting.add(FactoryPanelPosition.read(c)));
        this.targetedBy.clear();
        NBTHelper.iterateCompoundList((class_2499)panelTag.method_10554("TargetedBy", 10), c -> this.targetedBy.put(FactoryPanelPosition.read(c), FactoryPanelConnection.read(c)));
        this.targetedByLinks.clear();
        NBTHelper.iterateCompoundList((class_2499)panelTag.method_10554("TargetedByLinks", 10), c -> this.targetedByLinks.put(FactoryPanelPosition.read(c).pos(), FactoryPanelConnection.read(c)));
        this.activeCraftingArrangement = NBTHelper.readItemList((class_2499)panelTag.method_10554("Craft", 10));
        this.recipeAddress = panelTag.method_10558("RecipeAddress");
        this.recipeOutput = panelTag.method_10550("RecipeOutput");
        if (nbt.method_10577("Restocker") && !clientPacket) {
            this.restockerPromises = RequestPromiseQueue.read(panelTag.method_10562("Promises"), () -> {});
            this.promisePrimedForMarkDirty = false;
        }
    }

    @Override
    public float getRenderDistance() {
        return 64.0f;
    }

    @Override
    public class_5250 formatValue(ValueSettingsBehaviour.ValueSettings value) {
        if (value.value() == 0) {
            return CreateLang.translateDirect("gui.factory_panel.inactive", new Object[0]);
        }
        return class_2561.method_43470((String)(Math.max((int)0, (int)value.value()) + (value.row() == 0 ? "" : "\u25a4")));
    }

    @Override
    public boolean setFilter(class_1799 stack) {
        class_1799 filter = stack.method_7972();
        if (stack.method_7909() instanceof FilterItem) {
            return false;
        }
        this.filter = FilterItemStack.of(filter);
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        return true;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Math.max((int)0, (int)settings.value());
        this.upTo = settings.row() == 0;
        this.panelBE().redraw = true;
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
        this.resetTimerSlightly();
        if (!this.getWorld().field_9236) {
            this.notifyRedstoneOutputs();
        }
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        int maxAmount = 100;
        return new ValueSettingsBoard((class_2561)CreateLang.translate("factory_panel.target_amount", new Object[0]).component(), maxAmount, 10, List.of(CreateLang.translate("schedule.condition.threshold.items", new Object[0]).component(), CreateLang.translate("schedule.condition.threshold.stacks", new Object[0]).component()), new ValueSettingsFormatter(this::formatValue));
    }

    @Override
    public class_5250 getLabel() {
        Object key = "";
        if (!this.targetedBy.isEmpty() && this.count == 0) {
            return CreateLang.translate("gui.factory_panel.no_target_amount_set", new Object[0]).style(class_124.field_1061).component();
        }
        if (this.isMissingAddress()) {
            return CreateLang.translate("gui.factory_panel.address_missing", new Object[0]).style(class_124.field_1061).component();
        }
        if (this.getFilter().method_7960()) {
            key = "factory_panel.new_factory_task";
        } else if (this.waitingForNetwork) {
            key = "factory_panel.some_links_unloaded";
        } else {
            if (this.getAmount() == 0 || this.targetedBy.isEmpty()) {
                return this.getFilter().method_7964().method_27662();
            }
            key = this.getFilter().method_7964().getString();
            if (this.redstonePowered) {
                key = (String)key + " " + CreateLang.translate("factory_panel.redstone_paused", new Object[0]).string();
            } else if (!this.satisfied) {
                key = (String)key + " " + CreateLang.translate("factory_panel.in_progress", new Object[0]).string();
            }
            return CreateLang.text((String)key).component();
        }
        return CreateLang.translate((String)key, new Object[0]).component();
    }

    @Override
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(this.upTo ? 0 : 1, this.count);
    }

    @Override
    public class_5250 getTip() {
        return CreateLang.translateDirect(this.filter.isEmpty() ? "logistics.filter.click_to_set" : "factory_panel.click_to_configure", new Object[0]);
    }

    @Override
    public class_5250 getAmountTip() {
        return CreateLang.translateDirect("factory_panel.hold_to_set_amount", new Object[0]);
    }

    @Override
    public class_5250 getCountLabelForValueBox() {
        String stacks;
        if (this.filter.isEmpty()) {
            return class_2561.method_43473();
        }
        if (this.waitingForNetwork) {
            return class_2561.method_43470((String)"?");
        }
        int levelInStorage = this.getLevelInStorage();
        boolean inf = levelInStorage >= 1000000000;
        int inStorage = levelInStorage / (this.upTo ? 1 : this.getFilter().method_7914());
        int promised = this.getPromised();
        String string = stacks = this.upTo ? "" : "\u25a4";
        if (this.count == 0) {
            return CreateLang.text((String)(inf ? "  \u221e" : inStorage + stacks)).color(15855592).component();
        }
        return CreateLang.text((String)(inf ? "  \u221e" : "   " + inStorage + stacks)).color(this.satisfied ? 14155688 : (this.promisedSatisfied ? 16764277 : 16760744)).add(CreateLang.text(promised == 0 ? "" : "\u23f6")).add(CreateLang.text("/").style(class_124.field_1068)).add(CreateLang.text(this.count + stacks + "  ").color(15855592)).component();
    }

    @Override
    public int netId() {
        return 2 + this.slot.ordinal();
    }

    @Override
    public boolean isCountVisible() {
        return !this.getFilter().method_7960();
    }

    @Override
    public BehaviourType<?> getType() {
        return FactoryPanelBehaviour.getTypeForSlot(this.slot);
    }

    public static BehaviourType<?> getTypeForSlot(FactoryPanelBlock.PanelSlot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case FactoryPanelBlock.PanelSlot.BOTTOM_LEFT -> BOTTOM_LEFT;
            case FactoryPanelBlock.PanelSlot.TOP_LEFT -> TOP_LEFT;
            case FactoryPanelBlock.PanelSlot.TOP_RIGHT -> TOP_RIGHT;
            case FactoryPanelBlock.PanelSlot.BOTTOM_RIGHT -> BOTTOM_RIGHT;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public void displayScreen(class_1657 player) {
        if (player instanceof class_746) {
            ScreenOpener.open((class_437)new FactoryPanelScreen(this));
        }
    }

    public int getIngredientStatusColor() {
        return this.count == 0 || this.isMissingAddress() || this.redstonePowered ? 0x888898 : (this.waitingForNetwork ? 0x5B3B3B : (this.satisfied ? 10420095 : (this.promisedSatisfied ? 0x22AFAF : 4026045)));
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.isActive() ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.FACTORY_GAUGE.method_8389()) : ItemRequirement.NONE;
    }

    @Override
    public boolean canShortInteract(class_1799 toApply) {
        return true;
    }

    @Override
    public boolean readFromClipboard(class_2487 tag, class_1657 player, class_2350 side, boolean simulate) {
        return false;
    }

    @Override
    public boolean writeToClipboard(class_2487 tag, class_2350 side) {
        return false;
    }

    private void tickOutline() {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> LogisticallyLinkedClientHandler.tickPanel(this));
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return FactoryPanelSetItemMenu.create(containerId, playerInventory, this);
    }

    public class_2561 method_5476() {
        return this.blockEntity.method_11010().method_26204().method_9518();
    }

    public String getFrogAddress() {
        PackagerBlockEntity packager = this.panelBE().getRestockedPackager();
        if (packager == null) {
            return null;
        }
        class_2586 class_25862 = packager.method_10997().method_8321(packager.method_11016().method_10084());
        if (class_25862 instanceof FrogportBlockEntity) {
            FrogportBlockEntity fpbe = (FrogportBlockEntity)class_25862;
            if (fpbe.addressFilter != null && !fpbe.addressFilter.isBlank()) {
                return fpbe.addressFilter;
            }
        }
        return null;
    }

    public static class ItemStackConnections
    extends ArrayList<FactoryPanelConnection> {
        public class_1799 item;
        public int totalAmount;

        public ItemStackConnections(class_1799 item) {
            this.item = item;
        }
    }
}

